import refreshTokenHelper from "../../../../../utils/refreshTokenHelper"
import forceLogoutHelper from "../../../../../utils/forceLogoutHelper"
import errorHandlingHelper from "../../../../../utils/errorHandlingHelper"
import fetchHelper from "../../../../../utils/fetchHelper"

const handleFunc = async (event: any, authToken: any = null) => {
  let data: any = {}
  const token = authToken ?? await getTokenHelper(event)
  const body = await readBody(event)

  let newObjValue = {}
  if(body.partnerGroupId) {
    newObjValue = {...newObjValue, 
      C_BP_Group_ID: {
        id: body.partnerGroupId,
        tableName: 'C_BP_Group'
      }
    }
  }
  if(body.warehouseId) {
    newObjValue = {...newObjValue, 
      M_Warehouse_ID: {
        id: body.warehouseId,
        tableName: 'M_Warehouse'
      }
    }
  }
  if(body.priceListId) {
    newObjValue = {...newObjValue, 
      M_PriceList_ID: {
        id: body.priceListId,
        tableName: 'M_PriceList'
      }
    }
  }
  if(body.activityId) {
    newObjValue = {...newObjValue, 
      C_Activity_ID: {
        id: body.activityId,
        tableName: 'C_Activity'
      }
    }
  }

  if(body.id) {
    const res: any = await fetchHelper(event, 'models/m_promotionprecondition/'+body.id, 'PUT', token, {
      isActive: body.isActive,
      //promotionCounter: body.promotionCounter,
      promotionUsageLimit: body.promotionUsageLimit,
      startDate: body.startDate,
      endDate: body.endDate,
      seqNo: body.seqNo,
      promotionCode: body.promotionCode,
      ...newObjValue,
      tableName: 'm_promotionprecondition'
    })
    if(res) {
      data = res
      data['status'] = 200
      data['message'] = ''
    }
  }

  return data
}

export default defineEventHandler(async (event) => {
  let data: any = {}

  try {
    data = await handleFunc(event)
  } catch(err: any) {
    try {
      let authToken: any = await refreshTokenHelper(event)
      data = await handleFunc(event, authToken)
    } catch(error: any) {
      data = errorHandlingHelper(err?.data ?? err, error?.data ?? error)
      forceLogoutHelper(event, data)
    }
  }

  return data
})